import time

# Most basic form of time -- in seconds from the epoch
# Your epoch is most likely January 1st, 1970, at midnight
t = time.time()
print("Current time: ", t)

# Basic timestamp -- defaults to current time, but you can pass
# in a number of seconds as well
print("Current time as timestamp: ", time.ctime(t))

# Figure out your epoch using time.gmtime(0) (0 seconds after the epoch)
print("Epoch: ", time.gmtime(0))

# See the current utctime with time.gmtime()
print("Current UTC (GMT) time: ", time.gmtime())

# See the current local time as a struct_time with time.localtime()
print("Current local time: ", time.localtime())

# Get your time zone and GMT offset with struct_time.tm_zone
# and struct_time.gmtoff
print("Your time zone: ", time.localtime().tm_zone)
print("Your GMT offset: ", time.localtime().tm_gmtoff)

# The epoch as a tuple
epoch = (1970, 1, 1, 0, 0, 0, 3, 1, 0)

# Getting the number of seconds past the epoch from a tuple
import calendar
print("Epoch as seconds: ", calendar.timegm(epoch))
# Remember that calendar.timegm() should be used for UTC times, 
# while time.mktime() is for local times.

# Basic string timestamp from a tuple/struct
stamp = time.asctime(epoch)

# More formatted string
print(time.strftime("%Y-%m-%d", epoch))
# Even more formatted string
print(time.strftime("In the year of %Y, the day is %A, day %-d of the fine month of %B"))

# Parsing time strings
parsed = time.strptime("2020-03-16", "%Y-%m-%d")
# Without formatting, this defaults to the timestamp format
stamp_parsed = time.strptime(time.asctime())